/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.Statement;
import lindenmayer.parser.SymbolConstant;
import lindenmayer.parser.SymbolVariable;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.Variable;
import lindenmayer.parser.WrongSignatureException;

public class SymbolInterpretation {
    SymbolVariable symbol;
    Statement[] statements;

    public SymbolInterpretation(SymbolVariable symbol, Statement[] statements) {
        this.symbol = symbol;
        this.statements = statements;
    }

    public void assignMethods(Map methodIdMap) throws WrongSignatureException, UnknownMethodException {
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].assignMethods(methodIdMap);
        }
    }

    public void assignVariables(Map variableIdMap) throws UndefinedVariableException {
        int i;
        HashMap<String, Variable> myVariableIdMap = new HashMap<String, Variable>(variableIdMap);
        Variable[] variables = this.symbol.parameters;
        if (variables != null) {
            for (i = 0; i < variables.length; ++i) {
                myVariableIdMap.put(variables[i].id, variables[i]);
            }
        }
        for (i = 0; i < this.statements.length; ++i) {
            this.statements[i].assignVariables(myVariableIdMap);
        }
    }

    public void execute(SymbolConstant symbolConstant) {
        this.symbol.retrieveValues(symbolConstant);
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].execute();
        }
    }

    public String toString() {
        String result = this.symbol.toString();
        result = String.valueOf(String.valueOf(result)).concat(" =\n(\n");
        for (int i = 0; i < this.statements.length; ++i) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.statements[i].toString())).concat("\n"))));
        }
        result = String.valueOf(String.valueOf(result)).concat(")");
        return result;
    }
}

