/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.Random;
import lindenmayer.parser.ConstantDefinition;
import lindenmayer.parser.Interpretation;
import lindenmayer.parser.Limitation;
import lindenmayer.parser.LimitationNone;
import lindenmayer.parser.LimitationUnary;
import lindenmayer.parser.LimitationUniformly;
import lindenmayer.parser.MathProvider;
import lindenmayer.parser.Provider;
import lindenmayer.parser.Rule;
import lindenmayer.parser.Substitution;
import lindenmayer.parser.SymbolConstant;
import lindenmayer.parser.SymbolDefinition;
import lindenmayer.parser.SymbolsDefinition;
import lindenmayer.parser.Table;
import lindenmayer.parser.UndefinedSymbolException;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.WordConstant;
import lindenmayer.parser.WrongSignatureException;

public class System {
    MathProvider mathProvider;
    ConstantDefinition constantDefinition;
    SymbolsDefinition symbols;
    WordConstant axiom;
    Substitution substitution;
    Limitation limitation;
    Interpretation interpretation;

    public System() {
        this.mathProvider = new MathProvider();
    }

    public System(SymbolsDefinition symbols, WordConstant axiom, Substitution substitution, Interpretation interpretation) {
        this.symbols = symbols;
        this.axiom = axiom;
        this.substitution = substitution;
        this.interpretation = interpretation;
    }

    public MathProvider getMathProvider() {
        return this.mathProvider;
    }

    public void setSymbolsDefintion(SymbolsDefinition symbols) {
        this.symbols = symbols;
    }

    public void setAxiom(WordConstant axiom) {
        this.axiom = axiom;
    }

    public WordConstant getAxiom() {
        return this.axiom;
    }

    public void setSubstitution(Substitution substitution) {
        this.substitution = substitution;
    }

    public void setLimitation(Limitation limitation) {
        this.limitation = limitation;
    }

    public Limitation getLimitation() {
        return this.limitation;
    }

    public void setInterpretation(Interpretation interpretation) {
        this.interpretation = interpretation;
    }

    public Interpretation getInterpretation() {
        return this.interpretation;
    }

    public SymbolDefinition getSymbolDefinitionById(String id) throws UndefinedSymbolException {
        return this.symbols.getById(id);
    }

    public void setConstantDefinition(ConstantDefinition constantDefinition) {
        this.constantDefinition = constantDefinition;
    }

    public ConstantDefinition getConstantDefinition() {
        return this.constantDefinition;
    }

    public void interpret(WordConstant word, Provider interpretationProvider) throws UnknownMethodException, WrongSignatureException, UndefinedVariableException {
        this.interpretation.setProvider(new Provider[]{this.mathProvider, this.constantDefinition, interpretationProvider});
        this.interpretation.execute(word);
    }

    public WordConstant deriveRandomly(WordConstant word, Random random, int depth) {
        if (this.limitation == null || this.limitation instanceof LimitationNone) {
            return this.deriveRandomlyLimitationNone(word, random, depth);
        }
        if (this.limitation instanceof LimitationUniformly) {
            return this.deriveRandomlyLimitationUniformly(word, random, depth);
        }
        if (this.limitation instanceof LimitationUnary) {
            return this.deriveRandomlyLimitationUnary(word, random, depth);
        }
        throw new IllegalStateException("Limitation not supported");
    }

    WordConstant deriveRandomlyLimitationNone(WordConstant word, Random random, int depth) {
        Table table = this.substitution.getTableRandomly(random);
        WordConstant[] results = new WordConstant[word.symbols.length];
        int resultLength = 0;
        for (int i = 0; i < word.symbols.length; ++i) {
            Rule rule = table.getApplyableRuleRandomly(word, i, random);
            if (rule != null) {
                results[i] = rule.apply(word, i);
                resultLength += results[i].symbols.length;
                continue;
            }
            results[i] = new WordConstant(new SymbolConstant[]{(SymbolConstant)word.symbols[i].clone()});
            ++resultLength;
        }
        SymbolConstant[] result = new SymbolConstant[resultLength];
        int j = 0;
        for (int i = 0; i < word.symbols.length; ++i) {
            java.lang.System.arraycopy(results[i].symbols, 0, result, j, results[i].symbols.length);
            j += results[i].symbols.length;
        }
        return new WordConstant(result);
    }

    public WordConstant deriveRandomlyLimitationUniformly(WordConstant word, Random random, int depth) {
        int i;
        int limitationCount = this.limitation.getLimitationCount(depth);
        Table table = this.substitution.getTableRandomly(random);
        WordConstant[] results = new WordConstant[word.symbols.length];
        int[] indexes = new int[word.symbols.length];
        for (int i2 = 0; i2 < word.symbols.length; ++i2) {
            indexes[i2] = i2;
        }
        int[] derivationIndexes = new int[limitationCount];
        for (int i3 = 0; i3 < limitationCount && i3 < word.symbols.length; ++i3) {
            int index = random.nextInt(word.symbols.length - i3);
            derivationIndexes[i3] = indexes[index];
            indexes[index] = indexes[word.symbols.length - i3 - 1];
        }
        int resultLength = 0;
        for (i = 0; i < limitationCount && i < word.symbols.length; ++i) {
            Rule rule = table.getApplyableRuleRandomly(word, derivationIndexes[i], random);
            if (rule != null) {
                results[derivationIndexes[i]] = rule.apply(word, derivationIndexes[i]);
                resultLength += results[derivationIndexes[i]].symbols.length;
                continue;
            }
            results[derivationIndexes[i]] = new WordConstant(new SymbolConstant[]{(SymbolConstant)word.symbols[derivationIndexes[i]].clone()});
            ++resultLength;
        }
        for (i = 0; i < word.symbols.length; ++i) {
            if (results[i] != null) continue;
            results[i] = new WordConstant(new SymbolConstant[]{(SymbolConstant)word.symbols[i].clone()});
            ++resultLength;
        }
        SymbolConstant[] result = new SymbolConstant[resultLength];
        int j = 0;
        for (int i4 = 0; i4 < word.symbols.length; ++i4) {
            java.lang.System.arraycopy(results[i4].symbols, 0, result, j, results[i4].symbols.length);
            j += results[i4].symbols.length;
        }
        return new WordConstant(result);
    }

    public WordConstant deriveRandomlyLimitationUnary(WordConstant word, Random random, int depth) {
        int limitationCount = this.limitation.getLimitationCount(depth);
        Table table = this.substitution.getTableRandomly(random);
        WordConstant[] results = new WordConstant[word.symbols.length];
        int[] indexes = new int[word.symbols.length];
        int resultLength = 0;
        for (int i = 0; i < word.symbols.length; ++i) {
            int j;
            if (results[i] != null) continue;
            SymbolDefinition symbol = word.symbols[i].symbol;
            int k = 0;
            for (j = i; j < word.symbols.length; ++j) {
                if (word.symbols[j].symbol != symbol) continue;
                indexes[k++] = j;
            }
            for (j = 0; j < k && j < limitationCount; ++j) {
                int r = random.nextInt(k - j);
                int index = indexes[r];
                indexes[r] = indexes[k - j - 1];
                indexes[k - j - 1] = index;
                Rule rule = table.getApplyableRuleRandomly(word, index, random);
                if (rule != null) {
                    results[index] = rule.apply(word, index);
                    resultLength += results[index].symbols.length;
                    continue;
                }
                results[index] = new WordConstant(new SymbolConstant[]{(SymbolConstant)word.symbols[index].clone()});
                ++resultLength;
            }
            for (j = 0; j < k; ++j) {
                int index = indexes[j];
                if (results[index] != null) continue;
                results[index] = new WordConstant(new SymbolConstant[]{(SymbolConstant)word.symbols[index].clone()});
                ++resultLength;
            }
        }
        SymbolConstant[] result = new SymbolConstant[resultLength];
        int j = 0;
        for (int i = 0; i < word.symbols.length; ++i) {
            java.lang.System.arraycopy(results[i].symbols, 0, result, j, results[i].symbols.length);
            j += results[i].symbols.length;
        }
        return new WordConstant(result);
    }

    public String toString() {
        String result = String.valueOf(String.valueOf(this.symbols.toString())).concat("\n");
        result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("axiom = ").append(this.axiom.toString()).append("\n"))))));
        result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.substitution.toString())).concat("\n"))));
        result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(this.interpretation.toString())));
        return result;
    }
}

